<?php

declare(strict_types=1);

namespace MyParcelNL\Sdk\src\Services;

final class CountryCodes
{
    /**
     * ISO 3166-1 alpha-2 country codes.
     */
    public const  CC_AD            = 'AD'; // Andorra
    public const  CC_AE            = 'AE'; // United Arab Emirates (the)
    public const  CC_AF            = 'AF'; // Afghanistan
    public const  CC_AG            = 'AG'; // Antigua and Barbuda
    public const  CC_AI            = 'AI'; // Anguilla
    public const  CC_AL            = 'AL'; // Albania
    public const  CC_AM            = 'AM'; // Armenia
    public const  CC_AN            = 'AN'; // Netherlands Antilles
    public const  CC_AO            = 'AO'; // Angola
    public const  CC_AQ            = 'AQ'; // Antarctica
    public const  CC_AR            = 'AR'; // Argentina
    public const  CC_AS            = 'AS'; // American Samoa
    public const  CC_AT            = 'AT'; // Austria
    public const  CC_AU            = 'AU'; // Australia
    public const  CC_AW            = 'AW'; // Aruba
    public const  CC_AX            = 'AX'; // Åland Islands
    public const  CC_AZ            = 'AZ'; // Azerbaijan
    public const  CC_BA            = 'BA'; // Bosnia and Herzegovina
    public const  CC_BB            = 'BB'; // Barbados
    public const  CC_BD            = 'BD'; // Bangladesh
    public const  CC_BE            = 'BE'; // Belgium
    public const  CC_BF            = 'BF'; // Burkina Faso
    public const  CC_BG            = 'BG'; // Bulgaria
    public const  CC_BH            = 'BH'; // Bahrain
    public const  CC_BI            = 'BI'; // Burundi
    public const  CC_BJ            = 'BJ'; // Benin
    public const  CC_BL            = 'BL'; // Saint Barthélemy
    public const  CC_BM            = 'BM'; // Bermuda
    public const  CC_BN            = 'BN'; // Brunei Darussalam
    public const  CC_BO            = 'BO'; // Bolivia (Plurinational State of)
    public const  CC_BQ            = 'BQ'; // Bonaire, Sint Eustatius and Saba
    public const  CC_BR            = 'BR'; // Brazil
    public const  CC_BS            = 'BS'; // Bahamas (the)
    public const  CC_BT            = 'BT'; // Bhutan
    public const  CC_BV            = 'BV'; // Bouvet Island
    public const  CC_BW            = 'BW'; // Botswana
    public const  CC_BY            = 'BY'; // Belarus
    public const  CC_BZ            = 'BZ'; // Belize
    public const  CC_CA            = 'CA'; // Canada
    public const  CC_CC            = 'CC'; // Cocos (Keeling) Islands (the)
    public const  CC_CD            = 'CD'; // Congo (the Democratic Republic of the)
    public const  CC_CF            = 'CF'; // Central African Republic (the)
    public const  CC_CG            = 'CG'; // Congo (the)
    public const  CC_CH            = 'CH'; // Switzerland
    public const  CC_CI            = 'CI'; // Côte d'Ivoire
    public const  CC_CK            = 'CK'; // Cook Islands (the)
    public const  CC_CL            = 'CL'; // Chile
    public const  CC_CM            = 'CM'; // Cameroon
    public const  CC_CN            = 'CN'; // China
    public const  CC_CO            = 'CO'; // Colombia
    public const  CC_CR            = 'CR'; // Costa Rica
    public const  CC_CU            = 'CU'; // Cuba
    public const  CC_CV            = 'CV'; // Cabo Verde
    public const  CC_CW            = 'CW'; // Curaçao
    public const  CC_CX            = 'CX'; // Christmas Island
    public const  CC_CY            = 'CY'; // Cyprus
    public const  CC_CZ            = 'CZ'; // Czechia
    public const  CC_DE            = 'DE'; // Germany
    public const  CC_DJ            = 'DJ'; // Djibouti
    public const  CC_DK            = 'DK'; // Denmark	DK
    public const  CC_DM            = 'DM'; // Dominica
    public const  CC_DO            = 'DO'; // Dominican Republic (the)
    public const  CC_DZ            = 'DZ'; // Algeria
    public const  CC_EC            = 'EC'; // Ecuador
    public const  CC_EE            = 'EE'; // Estonia
    public const  CC_EG            = 'EG'; // Egypt
    public const  CC_EH            = 'EH'; // Western Sahara
    public const  CC_ER            = 'ER'; // Eritrea
    public const  CC_ES            = 'ES'; // Spain
    public const  CC_ET            = 'ET'; // Ethiopia
    public const  CC_FI            = 'FI'; // Finland
    public const  CC_FJ            = 'FJ'; // Fiji
    public const  CC_FK            = 'FK'; // Falkland Islands (the) [Malvinas]
    public const  CC_FM            = 'FM'; // Micronesia (Federated States of)
    public const  CC_FO            = 'FO'; // Faroe Islands (the)
    public const  CC_FR            = 'FR'; // France
    public const  CC_GA            = 'GA'; // Gabon
    public const  CC_GB            = 'GB'; // United Kingdom of Great Britain and Northern Ireland (the)
    public const  CC_GD            = 'GD'; // Grenada
    public const  CC_GE            = 'GE'; // Georgia
    public const  CC_GF            = 'GF'; // French Guiana
    public const  CC_GG            = 'GG'; // Guernsey
    public const  CC_GH            = 'GH'; // Ghana
    public const  CC_GI            = 'GI'; // Gibraltar
    public const  CC_GL            = 'GL'; // Greenland
    public const  CC_GM            = 'GM'; // Gambia (the)
    public const  CC_GN            = 'GN'; // Guinea
    public const  CC_GP            = 'GP'; // Guadeloupe
    public const  CC_GQ            = 'GQ'; // Equatorial Guinea
    public const  CC_GR            = 'GR'; // Greece
    public const  CC_GS            = 'GS'; // South Georgia and the South Sandwich Islands
    public const  CC_GT            = 'GT'; // Guatemala
    public const  CC_GU            = 'GU'; // Guam
    public const  CC_GW            = 'GW'; // Guinea-Bissau
    public const  CC_GY            = 'GY'; // Guyana
    public const  CC_HK            = 'HK'; // Hong Kong
    public const  CC_HM            = 'HM'; // Heard Island and McDonald Islands
    public const  CC_HN            = 'HN'; // Honduras
    public const  CC_HR            = 'HR'; // Croatia
    public const  CC_HT            = 'HT'; // Haiti
    public const  CC_HU            = 'HU'; // Hungary
    public const  CC_ID            = 'ID'; // Indonesia
    public const  CC_IE            = 'IE'; // Ireland
    public const  CC_IL            = 'IL'; // Israel
    public const  CC_IM            = 'IM'; // Isle of Man
    public const  CC_IN            = 'IN'; // India
    public const  CC_IO            = 'IO'; // British Indian Ocean Territory (the)
    public const  CC_IQ            = 'IQ'; // Iraq
    public const  CC_IR            = 'IR'; // Iran (Islamic Republic of)
    public const  CC_IS            = 'IS'; // Iceland
    public const  CC_IT            = 'IT'; // Italy
    public const  CC_JE            = 'JE'; // Jersey
    public const  CC_JM            = 'JM'; // Jamaica
    public const  CC_JO            = 'JO'; // Jordan
    public const  CC_JP            = 'JP'; // Japan
    public const  CC_KE            = 'KE'; // Kenya
    public const  CC_KG            = 'KG'; // Kyrgyzstan
    public const  CC_KH            = 'KH'; // Cambodia
    public const  CC_KI            = 'KI'; // Kiribati
    public const  CC_KM            = 'KM'; // Comoros (the)
    public const  CC_KN            = 'KN'; // Saint Kitts and Nevis
    public const  CC_KP            = 'KP'; // Korea (the Democratic People's Republic of)
    public const  CC_KR            = 'KR'; // Korea (the Republic of)
    public const  CC_KW            = 'KW'; // Kuwait
    public const  CC_KY            = 'KY'; // Cayman Islands (the)
    public const  CC_KZ            = 'KZ'; // Kazakhstan
    public const  CC_LA            = 'LA'; // Lao People's Democratic Republic (the)
    public const  CC_LB            = 'LB'; // Lebanon
    public const  CC_LC            = 'LC'; // Saint Lucia
    public const  CC_LI            = 'LI'; // Liechtenstein
    public const  CC_LK            = 'LK'; // Sri Lanka
    public const  CC_LR            = 'LR'; // Liberia
    public const  CC_LS            = 'LS'; // Lesotho
    public const  CC_LT            = 'LT'; // Lithuania
    public const  CC_LU            = 'LU'; // Luxembourg
    public const  CC_LV            = 'LV'; // Latvia
    public const  CC_LY            = 'LY'; // Libya
    public const  CC_MA            = 'MA'; // Morocco
    public const  CC_MC            = 'MC'; // Monaco
    public const  CC_MD            = 'MD'; // Moldova (the Republic of)
    public const  CC_ME            = 'ME'; // Montenegro
    public const  CC_MF            = 'MF'; // Saint Martin (French part)
    public const  CC_MG            = 'MG'; // Madagascar
    public const  CC_MH            = 'MH'; // Marshall Islands (the)
    public const  CC_MK            = 'MK'; // Republic of North Macedonia
    public const  CC_ML            = 'ML'; // Mali
    public const  CC_MM            = 'MM'; // Myanmar
    public const  CC_MN            = 'MN'; // Mongolia
    public const  CC_MO            = 'MO'; // Macao
    public const  CC_MP            = 'MP'; // Northern Mariana Islands (the)
    public const  CC_MQ            = 'MQ'; // Martinique
    public const  CC_MR            = 'MR'; // Mauritania
    public const  CC_MS            = 'MS'; // Montserrat
    public const  CC_MT            = 'MT'; // Malta
    public const  CC_MU            = 'MU'; // Mauritius
    public const  CC_MV            = 'MV'; // Maldives
    public const  CC_MW            = 'MW'; // Malawi
    public const  CC_MX            = 'MX'; // Mexico
    public const  CC_MY            = 'MY'; // Malaysia
    public const  CC_MZ            = 'MZ'; // Mozambique
    public const  CC_NA            = 'NA'; // Namibia
    public const  CC_NC            = 'NC'; // New Caledonia
    public const  CC_NE            = 'NE'; // Niger (the)
    public const  CC_NF            = 'NF'; // Norfolk Island
    public const  CC_NG            = 'NG'; // Nigeria
    public const  CC_NI            = 'NI'; // Nicaragua
    public const  CC_NL            = 'NL'; // Netherlands (the)
    public const  CC_NO            = 'NO'; // Norway
    public const  CC_NP            = 'NP'; // Nepal
    public const  CC_NR            = 'NR'; // Nauru
    public const  CC_NU            = 'NU'; // Niue
    public const  CC_NZ            = 'NZ'; // New Zealand
    public const  CC_OM            = 'OM'; // Oman
    public const  CC_PA            = 'PA'; // Panama
    public const  CC_PE            = 'PE'; // Peru
    public const  CC_PF            = 'PF'; // French Polynesia
    public const  CC_PG            = 'PG'; // Papua New Guinea
    public const  CC_PH            = 'PH'; // Philippines (the)
    public const  CC_PK            = 'PK'; // Pakistan
    public const  CC_PL            = 'PL'; // Poland
    public const  CC_PM            = 'PM'; // Saint Pierre and Miquelon
    public const  CC_PN            = 'PN'; // Pitcairn
    public const  CC_PR            = 'PR'; // Puerto Rico
    public const  CC_PS            = 'PS'; // Palestine, State of
    public const  CC_PT            = 'PT'; // Portugal
    public const  CC_PW            = 'PW'; // Palau
    public const  CC_PY            = 'PY'; // Paraguay
    public const  CC_QA            = 'QA'; // Qatar
    public const  CC_RE            = 'RE'; // Réunion
    public const  CC_RO            = 'RO'; // Romania
    public const  CC_RS            = 'RS'; // Serbia
    public const  CC_RU            = 'RU'; // Russian Federation (the)
    public const  CC_RW            = 'RW'; // Rwanda
    public const  CC_SA            = 'SA'; // Saudi Arabia
    public const  CC_SB            = 'SB'; // Solomon Islands
    public const  CC_SC            = 'SC'; // Seychelles
    public const  CC_SD            = 'SD'; // Sudan (the)
    public const  CC_SE            = 'SE'; // Sweden
    public const  CC_SG            = 'SG'; // Singapore
    public const  CC_SH            = 'SH'; // Saint Helena, Ascension and Tristan da Cunha
    public const  CC_SI            = 'SI'; // Slovenia
    public const  CC_SJ            = 'SJ'; // Svalbard and Jan Mayen
    public const  CC_SK            = 'SK'; // Slovakia
    public const  CC_SL            = 'SL'; // Sierra Leone
    public const  CC_SM            = 'SM'; // San Marino
    public const  CC_SN            = 'SN'; // Senegal
    public const  CC_SO            = 'SO'; // Somalia
    public const  CC_SR            = 'SR'; // Suriname
    public const  CC_SS            = 'SS'; // South Sudan
    public const  CC_ST            = 'ST'; // Sao Tome and Principe
    public const  CC_SV            = 'SV'; // El Salvador
    public const  CC_SX            = 'SX'; // Sint Maarten (Dutch part)
    public const  CC_SY            = 'SY'; // Syrian Arab Republic
    public const  CC_SZ            = 'SZ'; // Eswatini
    public const  CC_TC            = 'TC'; // Turks and Caicos Islands (the)
    public const  CC_TD            = 'TD'; // Chad
    public const  CC_TF            = 'TF'; // French Southern Territories (the)
    public const  CC_TG            = 'TG'; // Togo
    public const  CC_TH            = 'TH'; // Thailand
    public const  CC_TJ            = 'TJ'; // Tajikistan
    public const  CC_TK            = 'TK'; // Tokelau
    public const  CC_TL            = 'TL'; // Timor-Leste
    public const  CC_TM            = 'TM'; // Turkmenistan
    public const  CC_TN            = 'TN'; // Tunisia
    public const  CC_TO            = 'TO'; // Tonga
    public const  CC_TR            = 'TR'; // Turkey
    public const  CC_TT            = 'TT'; // Trinidad and Tobago
    public const  CC_TV            = 'TV'; // Tuvalu
    public const  CC_TW            = 'TW'; // Taiwan (Province of China)
    public const  CC_TZ            = 'TZ'; // Tanzania, United Republic of
    public const  CC_UA            = 'UA'; // Ukraine
    public const  CC_UG            = 'UG'; // Uganda
    public const  CC_UM            = 'UM'; // United States Minor Outlying Islands (the)
    public const  CC_US            = 'US'; // United States of America (the)
    public const  CC_UY            = 'UY'; // Uruguay
    public const  CC_UZ            = 'UZ'; // Uzbekistan
    public const  CC_VA            = 'VA'; // Holy See (the)
    public const  CC_VC            = 'VC'; // Saint Vincent and the Grenadines
    public const  CC_VE            = 'VE'; // Venezuela (Bolivarian Republic of)
    public const  CC_VG            = 'VG'; // Virgin Islands (British)
    public const  CC_VI            = 'VI'; // Virgin Islands (U.S.)
    public const  CC_VN            = 'VN'; // Viet Nam
    public const  CC_VU            = 'VU'; // Vanuatu
    public const  CC_WF            = 'WF'; // Wallis and Futuna
    public const  CC_WS            = 'WS'; // Samoa
    public const  CC_XK            = 'XK'; // Kosovo
    public const  CC_YE            = 'YE'; // Yemen
    public const  CC_YT            = 'YT'; // Mayotte
    public const  CC_ZA            = 'ZA'; // South Africa
    public const  CC_ZM            = 'ZM'; // Zambia
    public const  CC_ZW            = 'ZW'; // Zimbabwe
    public const  ZONE_EU          = 'EU';
    public const  ZONE_ROW         = 'ROW';
    public const  EU_COUNTRIES     = [
        self::CC_AT,
        self::CC_BE,
        self::CC_BG,
        self::CC_CY,
        self::CC_CZ,
        self::CC_DE,
        self::CC_DK,
        self::CC_EE,
        self::CC_ES,
        self::CC_FI,
        self::CC_FR,
        self::CC_GR,
        self::CC_HR,
        self::CC_HU,
        self::CC_IE,
        self::CC_IT,
        self::CC_LT,
        self::CC_LU,
        self::CC_LV,
        self::CC_MT,
        self::CC_NL,
        self::CC_PL,
        self::CC_PT,
        self::CC_RO,
        self::CC_SE,
        self::CC_SI,
        self::CC_SK,
    ];
    public const  ALL              = [
        self::CC_AD,
        self::CC_AE,
        self::CC_AF,
        self::CC_AG,
        self::CC_AI,
        self::CC_AL,
        self::CC_AM,
        self::CC_AN,
        self::CC_AO,
        self::CC_AQ,
        self::CC_AR,
        self::CC_AS,
        self::CC_AT,
        self::CC_AU,
        self::CC_AW,
        self::CC_AX,
        self::CC_AZ,
        self::CC_BA,
        self::CC_BB,
        self::CC_BD,
        self::CC_BE,
        self::CC_BF,
        self::CC_BG,
        self::CC_BH,
        self::CC_BI,
        self::CC_BJ,
        self::CC_BL,
        self::CC_BM,
        self::CC_BN,
        self::CC_BO,
        self::CC_BQ,
        self::CC_BR,
        self::CC_BS,
        self::CC_BT,
        self::CC_BV,
        self::CC_BW,
        self::CC_BY,
        self::CC_BZ,
        self::CC_CA,
        self::CC_CC,
        self::CC_CD,
        self::CC_CF,
        self::CC_CG,
        self::CC_CH,
        self::CC_CI,
        self::CC_CK,
        self::CC_CL,
        self::CC_CM,
        self::CC_CN,
        self::CC_CO,
        self::CC_CR,
        self::CC_CU,
        self::CC_CV,
        self::CC_CW,
        self::CC_CX,
        self::CC_CY,
        self::CC_CZ,
        self::CC_DE,
        self::CC_DJ,
        self::CC_DK,
        self::CC_DM,
        self::CC_DO,
        self::CC_DZ,
        self::CC_EC,
        self::CC_EE,
        self::CC_EG,
        self::CC_EH,
        self::CC_ER,
        self::CC_ES,
        self::CC_ET,
        self::CC_FI,
        self::CC_FJ,
        self::CC_FK,
        self::CC_FM,
        self::CC_FO,
        self::CC_FR,
        self::CC_GA,
        self::CC_GB,
        self::CC_GD,
        self::CC_GE,
        self::CC_GF,
        self::CC_GG,
        self::CC_GH,
        self::CC_GI,
        self::CC_GL,
        self::CC_GM,
        self::CC_GN,
        self::CC_GP,
        self::CC_GQ,
        self::CC_GR,
        self::CC_GS,
        self::CC_GT,
        self::CC_GU,
        self::CC_GW,
        self::CC_GY,
        self::CC_HK,
        self::CC_HM,
        self::CC_HN,
        self::CC_HR,
        self::CC_HT,
        self::CC_HU,
        self::CC_ID,
        self::CC_IE,
        self::CC_IL,
        self::CC_IM,
        self::CC_IN,
        self::CC_IO,
        self::CC_IQ,
        self::CC_IR,
        self::CC_IS,
        self::CC_IT,
        self::CC_JE,
        self::CC_JM,
        self::CC_JO,
        self::CC_JP,
        self::CC_KE,
        self::CC_KG,
        self::CC_KH,
        self::CC_KI,
        self::CC_KM,
        self::CC_KN,
        self::CC_KP,
        self::CC_KR,
        self::CC_KW,
        self::CC_KY,
        self::CC_KZ,
        self::CC_LA,
        self::CC_LB,
        self::CC_LC,
        self::CC_LI,
        self::CC_LK,
        self::CC_LR,
        self::CC_LS,
        self::CC_LT,
        self::CC_LU,
        self::CC_LV,
        self::CC_LY,
        self::CC_MA,
        self::CC_MC,
        self::CC_MD,
        self::CC_ME,
        self::CC_MF,
        self::CC_MG,
        self::CC_MH,
        self::CC_MK,
        self::CC_ML,
        self::CC_MM,
        self::CC_MN,
        self::CC_MO,
        self::CC_MP,
        self::CC_MQ,
        self::CC_MR,
        self::CC_MS,
        self::CC_MT,
        self::CC_MU,
        self::CC_MV,
        self::CC_MW,
        self::CC_MX,
        self::CC_MY,
        self::CC_MZ,
        self::CC_NA,
        self::CC_NC,
        self::CC_NE,
        self::CC_NF,
        self::CC_NG,
        self::CC_NI,
        self::CC_NL,
        self::CC_NO,
        self::CC_NP,
        self::CC_NR,
        self::CC_NU,
        self::CC_NZ,
        self::CC_OM,
        self::CC_PA,
        self::CC_PE,
        self::CC_PF,
        self::CC_PG,
        self::CC_PH,
        self::CC_PK,
        self::CC_PL,
        self::CC_PM,
        self::CC_PN,
        self::CC_PR,
        self::CC_PS,
        self::CC_PT,
        self::CC_PW,
        self::CC_PY,
        self::CC_QA,
        self::CC_RE,
        self::CC_RO,
        self::CC_RS,
        self::CC_RU,
        self::CC_RW,
        self::CC_SA,
        self::CC_SB,
        self::CC_SC,
        self::CC_SD,
        self::CC_SE,
        self::CC_SG,
        self::CC_SH,
        self::CC_SI,
        self::CC_SJ,
        self::CC_SK,
        self::CC_SL,
        self::CC_SM,
        self::CC_SN,
        self::CC_SO,
        self::CC_SR,
        self::CC_SS,
        self::CC_ST,
        self::CC_SV,
        self::CC_SX,
        self::CC_SY,
        self::CC_SZ,
        self::CC_TC,
        self::CC_TD,
        self::CC_TF,
        self::CC_TG,
        self::CC_TH,
        self::CC_TJ,
        self::CC_TK,
        self::CC_TL,
        self::CC_TM,
        self::CC_TN,
        self::CC_TO,
        self::CC_TR,
        self::CC_TT,
        self::CC_TV,
        self::CC_TW,
        self::CC_TZ,
        self::CC_UA,
        self::CC_UG,
        self::CC_UM,
        self::CC_US,
        self::CC_UY,
        self::CC_UZ,
        self::CC_VA,
        self::CC_VC,
        self::CC_VE,
        self::CC_VG,
        self::CC_VI,
        self::CC_VN,
        self::CC_VU,
        self::CC_WF,
        self::CC_WS,
        self::CC_XK,
        self::CC_YE,
        self::CC_YT,
        self::CC_ZA,
        self::CC_ZM,
        self::CC_ZW,
    ];
    public const  UNIQUE_COUNTRIES = [self::CC_NL, self::CC_BE];
}
