# Changelog

All notable changes to this project will be documented in this file. See
[Conventional Commits](https://conventionalcommits.org) for commit guidelines.

## [7.20.0](https://github.com/myparcelnl/sdk/compare/v7.19.0...v7.20.0) (2024-11-15)


### :sparkles: New Features

* Allow saturday delivery for DHLForYou ([#510](https://github.com/myparcelnl/sdk/issues/510)) ([f33483e](https://github.com/myparcelnl/sdk/commit/f33483e804a168801a8dcb4a47b8a82163d13bf3))

## [7.19.0](https://github.com/myparcelnl/sdk/compare/v7.18.1...v7.19.0) (2024-11-14)


### :sparkles: New Features

* **carriers:** add ups shipping options ([#509](https://github.com/myparcelnl/sdk/issues/509)) ([dbaf617](https://github.com/myparcelnl/sdk/commit/dbaf6176f7a1b34e405e63ad9b14a67facf3787f))

## [7.18.1](https://github.com/myparcelnl/sdk/compare/v7.18.0...v7.18.1) (2024-11-07)


### :bug: Bug Fixes

* support capital letters in box number detection ([#508](https://github.com/myparcelnl/sdk/issues/508)) ([98d4a0d](https://github.com/myparcelnl/sdk/commit/98d4a0de33808225ee7a6a1a96212a3334aeaa45))

## [7.18.0](https://github.com/myparcelnl/sdk/compare/v7.17.0...v7.18.0) (2024-10-23)


### :bug: Bug Fixes

* comment out default weight in BpostConsignment model ([#499](https://github.com/myparcelnl/sdk/issues/499)) ([1e01ce2](https://github.com/myparcelnl/sdk/commit/1e01ce272874af419a69e2ba20d6a3ed36b51ea2))


### :sparkles: New Features

* add receipt code ([#507](https://github.com/myparcelnl/sdk/issues/507)) ([e794021](https://github.com/myparcelnl/sdk/commit/e794021b4bdbcc553c29627bb95f3947386de4e3))

## [7.17.0](https://github.com/myparcelnl/sdk/compare/v7.16.2...v7.17.0) (2024-09-30)


### :sparkles: New Features

* allow small package with DHLForYou ([#506](https://github.com/myparcelnl/sdk/issues/506)) ([43b9694](https://github.com/myparcelnl/sdk/commit/43b96946831e59877d45d3004871bf7dfe51b352))

## [7.16.2](https://github.com/myparcelnl/sdk/compare/v7.16.1...v7.16.2) (2024-09-24)


### :bug: Bug Fixes

* **export:** export addresses consistently ([#502](https://github.com/myparcelnl/sdk/issues/502)) ([049a1ac](https://github.com/myparcelnl/sdk/commit/049a1ac5e948bcbb10bd09804eacfbd5e48a12df))

## [7.16.1](https://github.com/myparcelnl/sdk/compare/v7.16.0...v7.16.1) (2024-09-19)


### :bug: Bug Fixes

* fix error physical properties DHLForYou ([#504](https://github.com/myparcelnl/sdk/issues/504)) ([7159c79](https://github.com/myparcelnl/sdk/commit/7159c79af18d11d91f1e4e20a4921faac7dd944b))

## [7.16.0](https://github.com/myparcelnl/sdk/compare/v7.15.4...v7.16.0) (2024-09-10)


### :sparkles: New Features

* prevent api errors for long person and company names ([#486](https://github.com/myparcelnl/sdk/issues/486)) ([5bb9271](https://github.com/myparcelnl/sdk/commit/5bb927192dd5f8b69137e592447ee27146509075))

## [7.15.4](https://github.com/myparcelnl/sdk/compare/v7.15.3...v7.15.4) (2024-08-13)


### :bug: Bug Fixes

* resolve error for small package BE creation ([#497](https://github.com/myparcelnl/sdk/issues/497)) ([05131e4](https://github.com/myparcelnl/sdk/commit/05131e4214effd5ab5da76a4e754e7c23b48ffc6))

## [7.15.3](https://github.com/myparcelnl/sdk/compare/v7.15.2...v7.15.3) (2024-08-08)


### :bug: Bug Fixes

* **splitstreet:** ensure box separator for be address ([#496](https://github.com/myparcelnl/sdk/issues/496)) ([2997ac8](https://github.com/myparcelnl/sdk/commit/2997ac8a5aa58dbcd87201a74b2a5c01c5532daf))

## [7.15.2](https://github.com/myparcelnl/sdk/compare/v7.15.1...v7.15.2) (2024-08-02)


### :bug: Bug Fixes

* **split-street:** get actual matches from belgium split street regex ([#494](https://github.com/myparcelnl/sdk/issues/494)) ([0bc97fd](https://github.com/myparcelnl/sdk/commit/0bc97fd80b11e4238436c74269a18e6916f53967))

## [7.15.1](https://github.com/myparcelnl/sdk/compare/v7.15.0...v7.15.1) (2024-07-23)


### :bug: Bug Fixes

* prevent adding array to int calculating total value ([#492](https://github.com/myparcelnl/sdk/issues/492)) ([ebc2ff8](https://github.com/myparcelnl/sdk/commit/ebc2ff8459c9c77b617789e8a76992fff0ddf928))

## [7.15.0](https://github.com/myparcelnl/sdk/compare/v7.14.1...v7.15.0) (2024-07-18)


### :rewind: Reverts

* revert unnecessary change ([be0b704](https://github.com/myparcelnl/sdk/commit/be0b7040d96148bfb3b5ca913e06fb5f50db1265))


### :sparkles: New Features

* add row insurance possibilities ([#489](https://github.com/myparcelnl/sdk/issues/489)) ([0fda2f2](https://github.com/myparcelnl/sdk/commit/0fda2f23d2ae638c2bfdfaca3c85d61c91957a92))

## [7.14.1](https://github.com/myparcelnl/sdk/compare/v7.14.0...v7.14.1) (2024-06-24)


### :bug: Bug Fixes

* fix physical properties constructor ([#485](https://github.com/myparcelnl/sdk/issues/485)) ([89ee368](https://github.com/myparcelnl/sdk/commit/89ee368cbfdd855796c4f73c3b55883525bba3ca))

## [7.14.0](https://github.com/myparcelnl/sdk/compare/v7.13.2...v7.14.0) (2024-06-21)


### :sparkles: New Features

* add physical properties properly ([#483](https://github.com/myparcelnl/sdk/issues/483)) ([d7e508c](https://github.com/myparcelnl/sdk/commit/d7e508c331cbe73b6df122e679e5f5418051b56d))

## [7.13.2](https://github.com/myparcelnl/sdk/compare/v7.13.1...v7.13.2) (2024-05-29)


### :bug: Bug Fixes

* remove dpd default weight ([#482](https://github.com/myparcelnl/sdk/issues/482)) ([070456f](https://github.com/myparcelnl/sdk/commit/070456fc1cc1a8a22b7540dfda966e6f8f89a06d))

## [7.13.1](https://github.com/myparcelnl/sdk/compare/v7.13.0...v7.13.1) (2024-04-22)


### :bug: Bug Fixes

* make shipmentOptions and pickupLocation properties snake_case for backwards compatibility ([#481](https://github.com/myparcelnl/sdk/issues/481)) ([f4ec38d](https://github.com/myparcelnl/sdk/commit/f4ec38d78615c16d6b4485279bb796cfb68b9f0d))

## [7.13.0](https://github.com/myparcelnl/sdk/compare/v7.12.1...v7.13.0) (2024-04-11)


### :sparkles: New Features

* allow package type mailbox for dpd ([#475](https://github.com/myparcelnl/sdk/issues/475)) ([a1326a3](https://github.com/myparcelnl/sdk/commit/a1326a3cb6241226b45c9835ace7ef32ae325e12))

## [7.12.1](https://github.com/myparcelnl/sdk/compare/v7.12.0...v7.12.1) (2024-04-05)


### :bug: Bug Fixes

* remove instabox ([#478](https://github.com/myparcelnl/sdk/issues/478)) ([20b74e6](https://github.com/myparcelnl/sdk/commit/20b74e6e6062eda5215358b4d24300bec127693d))

## [7.12.0](https://github.com/myparcelnl/sdk/compare/v7.11.0...v7.12.0) (2024-03-25)


### :sparkles: New Features

* add international bbp ([#476](https://github.com/myparcelnl/sdk/issues/476)) ([453c590](https://github.com/myparcelnl/sdk/commit/453c59079c9befcd38db066a7fdcae1ef7743a86))

## [7.11.0](https://github.com/myparcelnl/sdk/compare/v7.10.1...v7.11.0) (2024-03-13)


### :sparkles: New Features

* add package type package_small ([#471](https://github.com/myparcelnl/sdk/issues/471)) ([dd72573](https://github.com/myparcelnl/sdk/commit/dd72573c968d9634e7f765e917bd26555f5db17d))

## [7.10.1](https://github.com/myparcelnl/sdk/compare/v7.10.0...v7.10.1) (2024-02-29)


### :bug: Bug Fixes

* retail_network_id null value found ([#473](https://github.com/myparcelnl/sdk/issues/473)) ([63113cc](https://github.com/myparcelnl/sdk/commit/63113cc01514a304788d4d9f48c0c5c4a0df3d1c))

## [7.10.0](https://github.com/myparcelnl/sdk/compare/v7.9.1...v7.10.0) (2024-02-01)


### :sparkles: New Features

* **consignment:** add state property ([#469](https://github.com/myparcelnl/sdk/issues/469)) ([3488251](https://github.com/myparcelnl/sdk/commit/3488251f211a77654039ce44ab0aaa12ffe1d979))

## [7.9.1](https://github.com/myparcelnl/sdk/compare/v7.9.0...v7.9.1) (2024-01-18)


### :bug: Bug Fixes

* **fulfilment:** export physical properties ([#465](https://github.com/myparcelnl/sdk/issues/465)) ([b7ea460](https://github.com/myparcelnl/sdk/commit/b7ea4609d61b2e39a7278d8bc6bcd30b6585d186))

## [7.9.0](https://github.com/myparcelnl/sdk/compare/v7.8.5...v7.9.0) (2023-12-08)


### :sparkles: New Features

* add carrier ups ([#463](https://github.com/myparcelnl/sdk/issues/463)) ([5ec154c](https://github.com/myparcelnl/sdk/commit/5ec154c3919d957ae69df47c2d62ead25edce1fa))

## [7.8.5](https://github.com/myparcelnl/sdk/compare/v7.8.4...v7.8.5) (2023-12-04)


### :bug: Bug Fixes

* correct dpd shipment options ([#464](https://github.com/myparcelnl/sdk/issues/464)) ([e454e13](https://github.com/myparcelnl/sdk/commit/e454e1361b0c9348fcd63fd8ddf6a961c9a1f459))

## [7.8.4](https://github.com/myparcelnl/sdk/compare/v7.8.3...v7.8.4) (2023-10-26)


### :bug: Bug Fixes

* **consignment:** replace part of box separator instead of fullstreet ([#441](https://github.com/myparcelnl/sdk/issues/441)) ([a2f1e29](https://github.com/myparcelnl/sdk/commit/a2f1e29b55d94be22b208869a88af6281fb2b544))

## [7.8.3](https://github.com/myparcelnl/sdk/compare/v7.8.2...v7.8.3) (2023-10-04)


### :bug: Bug Fixes

* ensure signature for europlus and parcel connect ([#460](https://github.com/myparcelnl/sdk/issues/460)) ([87a6931](https://github.com/myparcelnl/sdk/commit/87a6931bea4598cab9196319585f6cedde8df6f2))

## [7.8.2](https://github.com/myparcelnl/sdk/compare/v7.8.1...v7.8.2) (2023-09-13)


### :bug: Bug Fixes

* allow 10 digit classification numbers ([#459](https://github.com/myparcelnl/sdk/issues/459)) ([595943a](https://github.com/myparcelnl/sdk/commit/595943a901aad1314248b27f5485935a7d917002))

## [7.8.1](https://github.com/myparcelnl/sdk/compare/v7.8.0...v7.8.1) (2023-09-13)


### :bug: Bug Fixes

* correct label positions doc block ([#458](https://github.com/myparcelnl/sdk/issues/458)) ([318c6e3](https://github.com/myparcelnl/sdk/commit/318c6e34802ad7ccc181647174f90b631668cb70))

## [7.8.0](https://github.com/myparcelnl/sdk/compare/v7.7.7...v7.8.0) (2023-07-17)


### :sparkles: New Features

* **fulfilment:** add order notes ([#456](https://github.com/myparcelnl/sdk/issues/456)) ([c8e2b5b](https://github.com/myparcelnl/sdk/commit/c8e2b5b5202417e124a55311c65f113632ed541c))

## [7.7.7](https://github.com/myparcelnl/sdk/compare/v7.7.6...v7.7.7) (2023-07-17)


### :bug: Bug Fixes

* **shipment:** fix setItemValueArray method ([#454](https://github.com/myparcelnl/sdk/issues/454)) ([e206068](https://github.com/myparcelnl/sdk/commit/e2060689ea21ce654f403058279a1ec89f7dfeb8))

## [7.7.6](https://github.com/myparcelnl/sdk/compare/v7.7.5...v7.7.6) (2023-07-10)


### :bug: Bug Fixes

* **encode:** use carrier specific options logic ([#455](https://github.com/myparcelnl/sdk/issues/455)) ([51bffc3](https://github.com/myparcelnl/sdk/commit/51bffc3512fbc0feeff45e22220df36cd3eeda30))

## [7.7.5](https://github.com/myparcelnl/sdk/compare/v7.7.4...v7.7.5) (2023-04-11)


### :bug: Bug Fixes

* default to postnl when carrier id is invalid ([#452](https://github.com/myparcelnl/sdk/issues/452)) ([fb1304d](https://github.com/myparcelnl/sdk/commit/fb1304defa799fa5b7233e8943cf07881cb43863))

## [7.7.4](https://github.com/myparcelnl/sdk/compare/v7.7.3...v7.7.4) (2023-04-04)


### :bug: Bug Fixes

* remove instabox from carrierfactory ([#449](https://github.com/myparcelnl/sdk/issues/449)) ([5bb7bee](https://github.com/myparcelnl/sdk/commit/5bb7bee160b438cc175a5e407e2eba5fcfbe37cb))

## [7.7.3](https://github.com/myparcelnl/sdk/compare/v7.7.2...v7.7.3) (2023-03-14)


### :bug: Bug Fixes

* keep fixed length when truncating with str::limit ([#433](https://github.com/myparcelnl/sdk/issues/433)) ([0d9cd02](https://github.com/myparcelnl/sdk/commit/0d9cd026159b4c1a7d97015e1767830b160dea6d))

## [7.7.2](https://github.com/myparcelnl/sdk/compare/v7.7.1...v7.7.2) (2023-03-03)


### :bug: Bug Fixes

* add valid insurance amounts for nl to be for postnl ([#448](https://github.com/myparcelnl/sdk/issues/448)) ([94e69f0](https://github.com/myparcelnl/sdk/commit/94e69f07c21825d94752c4774ae9daa272608cd1))

## [7.7.1](https://github.com/myparcelnl/sdk/compare/v7.7.0...v7.7.1) (2023-03-01)


### :bug: Bug Fixes

* add exceptions for dhl carriers ([#447](https://github.com/myparcelnl/sdk/issues/447)) ([959b232](https://github.com/myparcelnl/sdk/commit/959b2327ad8975e64fd7e6d32706da586c5af9e0))

## [7.7.0](https://github.com/myparcelnl/sdk/compare/v7.6.2...v7.7.0) (2023-02-24)


### :sparkles: New Features

* add all dhl carriers ([#446](https://github.com/myparcelnl/sdk/issues/446)) ([0d1cb21](https://github.com/myparcelnl/sdk/commit/0d1cb2127b971d7190c81140229abeb0e95e6f25))

## [7.6.2](https://github.com/myparcelnl/sdk/compare/v7.6.1...v7.6.2) (2023-02-20)


### :bug: Bug Fixes

* **consignment:** add croatian country code ([#444](https://github.com/myparcelnl/sdk/issues/444)) ([526e007](https://github.com/myparcelnl/sdk/commit/526e007532aa99375d8bad1b5a76661ba9c9da07)), closes [#443](https://github.com/myparcelnl/sdk/issues/443)
* **consignment:** type error on getting shop id ([#436](https://github.com/myparcelnl/sdk/issues/436)) ([aae620a](https://github.com/myparcelnl/sdk/commit/aae620a9ecbdde2deaf51ec850c9c3b1aaa48925))
* use correct insurance format ([#445](https://github.com/myparcelnl/sdk/issues/445)) ([78318aa](https://github.com/myparcelnl/sdk/commit/78318aa1404574fc93c89a250c6079e295e90317))

## [7.6.1](https://github.com/myparcelnl/sdk/compare/v7.6.0...v7.6.1) (2023-01-02)


### :bug: Bug Fixes

* **consignment:** make insurance possibilities cc parameter optional ([2bf29b0](https://github.com/myparcelnl/sdk/commit/2bf29b0435d8dc9d98faf4cf7d9ffa6f03ce76e4))

## [7.6.0](https://github.com/myparcelnl/sdk/compare/v7.5.1...v7.6.0) (2022-12-30)


### :sparkles: New Features

* add insurance possibilities for eu shipments ([#429](https://github.com/myparcelnl/sdk/issues/429)) ([da725c8](https://github.com/myparcelnl/sdk/commit/da725c8e66875b14fe9daff472bdafabbef68373))

## [7.5.1](https://github.com/myparcelnl/sdk/compare/v7.5.0...v7.5.1) (2022-12-16)


### :bug: Bug Fixes

* **collection:** allow array in toArray ([#434](https://github.com/myparcelnl/sdk/issues/434)) ([73bfd46](https://github.com/myparcelnl/sdk/commit/73bfd463f537ab7d547021cb96e01a50c0851743))

## [7.5.0](https://github.com/myparcelnl/sdk/compare/v7.4.4...v7.5.0) (2022-12-05)


### :sparkles: New Features

* add carrier dhl ([#428](https://github.com/myparcelnl/sdk/issues/428)) ([d1d56cf](https://github.com/myparcelnl/sdk/commit/d1d56cf96b7bcedf94a1d335749409773a6a8471))

## [7.4.4](https://github.com/myparcelnl/sdk/compare/v7.4.3...v7.4.4) (2022-09-09)


### :bug: Bug Fixes

* remove lockfile ([563fd76](https://github.com/myparcelnl/sdk/commit/563fd76201f41a60c11a63f26a7b3985c1f4ddba))

## [7.4.3](https://github.com/myparcelnl/sdk/compare/v7.4.2...v7.4.3) (2022-07-20)


### :bug: Bug Fixes

* allow null as pickup location country ([#426](https://github.com/myparcelnl/sdk/issues/426)) ([7af1e83](https://github.com/myparcelnl/sdk/commit/7af1e83081f28620064b38da13abaea5a632351d))

## [7.4.2](https://github.com/myparcelnl/sdk/compare/v7.4.1...v7.4.2) (2022-07-14)


### :bug: Bug Fixes

* support a maximum of 6 characters for the classification ([#425](https://github.com/myparcelnl/sdk/issues/425)) ([4bea27b](https://github.com/myparcelnl/sdk/commit/4bea27b36eb7d491095d5f11c99bb7be973b5c2d))

## [7.4.1](https://github.com/myparcelnl/sdk/compare/v7.4.0...v7.4.1) (2022-07-12)


### :bug: Bug Fixes

* import closure in helpers ([6e540b2](https://github.com/myparcelnl/sdk/commit/6e540b26b7cca5adb6de19aede67191a7c708914))

## [7.4.0](https://github.com/myparcelnl/sdk/compare/v7.3.1...v7.4.0) (2022-07-11)


### :sparkles: New Features

* add helper function checking empty values in array ([#423](https://github.com/myparcelnl/sdk/issues/423)) ([f0e6549](https://github.com/myparcelnl/sdk/commit/f0e65494daa40576745c42cdf301662365d781fc))

## [7.3.1](https://github.com/myparcelnl/sdk/compare/v7.3.0...v7.3.1) (2022-07-11)


### :bug: Bug Fixes

* consignment status given default value ([#424](https://github.com/myparcelnl/sdk/issues/424)) ([0df494e](https://github.com/myparcelnl/sdk/commit/0df494e358d3cf80b196e5a7d2ef687a7f7c705d))

## [7.3.0](https://github.com/myparcelnl/sdk/compare/v7.2.2...v7.3.0) (2022-06-16)


### :sparkles: New Features

* add order status webhook and add shipments to order ([#414](https://github.com/myparcelnl/sdk/issues/414)) ([ae89f92](https://github.com/myparcelnl/sdk/commit/ae89f92b4063b4f08da40b199c121732a38fce60))
* add weight validation to consignment ([#411](https://github.com/myparcelnl/sdk/issues/411)) ([d2cf46e](https://github.com/myparcelnl/sdk/commit/d2cf46eeb12d9d4d658ad61fd73e23d2041754f5))


### :bug: Bug Fixes

* adjust instabox shipment for ConsignmentAdapter usage ([#406](https://github.com/myparcelnl/sdk/issues/406)) ([ab0e6c7](https://github.com/myparcelnl/sdk/commit/ab0e6c756b5dd46958e476edc3619e138df56ac5))
* restore deprecated constant ([#416](https://github.com/myparcelnl/sdk/issues/416)) ([ffffa0d](https://github.com/myparcelnl/sdk/commit/ffffa0d2360809bf91f4bd9d2fb1669b9c37d71a))

### [7.2.2](https://github.com/myparcelnl/sdk/compare/v7.2.1...v7.2.2) (2022-04-15)


### :bug: Bug Fixes

* add drop-off point validation for orders ([#407](https://github.com/myparcelnl/sdk/issues/407)) ([0b6aa79](https://github.com/myparcelnl/sdk/commit/0b6aa7966d3f66d8de929c0ddebdda4c8f68a62f))

### [7.2.1](https://github.com/myparcelnl/sdk/compare/v7.2.0...v7.2.1) (2022-04-11)


### :bug: Bug Fixes

* **consignment:** allow omitting insurance field ([#409](https://github.com/myparcelnl/sdk/issues/409)) ([810ac4e](https://github.com/myparcelnl/sdk/commit/810ac4e46f82b8d8726a08d360b1f26fb7fad243))

## [7.2.0](https://github.com/myparcelnl/sdk/compare/v7.1.0...v7.2.0) (2022-04-11)


### :bug: Bug Fixes

* allow 6 characters for number suffix ([#399](https://github.com/myparcelnl/sdk/issues/399)) ([05f9ff3](https://github.com/myparcelnl/sdk/commit/05f9ff37dc578b81d03dfa9c6eb7339b143560f2))
* **consignment:** fix insurance from api not being set ([#396](https://github.com/myparcelnl/sdk/issues/396)) ([ffe8a87](https://github.com/myparcelnl/sdk/commit/ffe8a878ba77c63224bafe8b883a1cf163424c49))
* cut off label description at 45 characters ([ff9aae5](https://github.com/myparcelnl/sdk/commit/ff9aae53d7772b42f62319cffa9e1a7732632521))


### :sparkles: New Features

* account for pickup with shipment options ([#395](https://github.com/myparcelnl/sdk/issues/395)) ([3ce7ad9](https://github.com/myparcelnl/sdk/commit/3ce7ad9192383fa39b3e45deb25151b733e0ef43))
* add HasInstance trait ([#402](https://github.com/myparcelnl/sdk/issues/402)) ([6ee0506](https://github.com/myparcelnl/sdk/commit/6ee0506669db5031e0c3ab797e5645dfb302e4ba))
* allow omitting delivery date with pickup ([#401](https://github.com/myparcelnl/sdk/issues/401)) ([f1603f0](https://github.com/myparcelnl/sdk/commit/f1603f0f9fc0288b9c9d3cd9752d67f07b079995))
* set reference identifier for return shipments ([#394](https://github.com/myparcelnl/sdk/issues/394)) ([957ccc2](https://github.com/myparcelnl/sdk/commit/957ccc24a1b9aae9abea4b1c6af9401f1c9efb76))

## [7.1.0](https://github.com/myparcelnl/sdk/compare/v7.0.0...v7.1.0) (2022-02-09)


### :sparkles: New Features

* **pps:** add drop-off point to order ([#387](https://github.com/myparcelnl/sdk/issues/387)) ([0722275](https://github.com/myparcelnl/sdk/commit/0722275ea724584b680c68786f435f809332d6b2))
* **pps:** add physical_properties to order ([a474cde](https://github.com/myparcelnl/sdk/commit/a474cdef040a5a5d57ea171f24ec8c82fdd6b5f6))


### :bug: Bug Fixes

* **pps:** accept null as dropoffpoint to avoid errors ([#391](https://github.com/myparcelnl/sdk/issues/391)) ([436af33](https://github.com/myparcelnl/sdk/commit/436af33093734d118e9bbb4c8c625c44f860155f))
* **pps:** datetime throwing error when null ([#385](https://github.com/myparcelnl/sdk/issues/385)) ([f3dd238](https://github.com/myparcelnl/sdk/commit/f3dd2383f3b89213a840853cdca2506f0e874514))
* **pps:** make number suffix in drop off point non-nullable ([#397](https://github.com/myparcelnl/sdk/issues/397)) ([395d5e5](https://github.com/myparcelnl/sdk/commit/395d5e5cd0c0bea89cc0431ca2c32ae76347eea3))
* use proprietary variable name in env ([#388](https://github.com/myparcelnl/sdk/issues/388)) ([98b6d7e](https://github.com/myparcelnl/sdk/commit/98b6d7eda2a6be3de296a67c9b298365fcbcf101))

## [7.0.0](https://github.com/myparcelnl/sdk/compare/v6.1.0...v7.0.0) (2022-02-09)


### ⚠ BREAKING CHANGES

* **instabox:** rename rjp to instabox (#348)

* **instabox:** rename rjp to instabox ([#348](https://github.com/myparcelnl/sdk/issues/348)) ([e1af3ce](https://github.com/myparcelnl/sdk/commit/e1af3ce859398eaa8db8b387199c9258160fae87))


### :sparkles: New Features

* **instabox:** add same day delivery ([#380](https://github.com/myparcelnl/sdk/issues/380)) ([e0725a9](https://github.com/myparcelnl/sdk/commit/e0725a9128ce452417c19b8af489faaf575a7e5a))
* **pps:** add delivery type to request body ([579925f](https://github.com/myparcelnl/sdk/commit/579925fe46b7d06ee9bad8eb4f7315fa5574dfc3))
* **pps:** add drop-off point to order ([#387](https://github.com/myparcelnl/sdk/issues/387)) ([5821c84](https://github.com/myparcelnl/sdk/commit/5821c8416c9ff3a3a5661a30f2eea33acbbdda19))
* **pps:** add physical_properties to order ([cd348f7](https://github.com/myparcelnl/sdk/commit/cd348f761b7180cfd0dcc664eb671cd685da2283))


### :bug: Bug Fixes

* **collection:** remove php8 deprecation warnings ([#376](https://github.com/myparcelnl/sdk/issues/376)) ([790c22b](https://github.com/myparcelnl/sdk/commit/790c22bbb524bce19da0a623d9f5e38f3b2d9bb6))
* **pps:** accept null as dropoffpoint to avoid errors ([#391](https://github.com/myparcelnl/sdk/issues/391)) ([8aff9a1](https://github.com/myparcelnl/sdk/commit/8aff9a1bb197167b58872184a3f944785b95e953))
* **pps:** datetime throwing error when null ([#385](https://github.com/myparcelnl/sdk/issues/385)) ([cafde44](https://github.com/myparcelnl/sdk/commit/cafde44c0bf39f35252f20a857d71f77715eb562))
* **pps:** fix export delivery options ([#369](https://github.com/myparcelnl/sdk/issues/369)) ([aabdb56](https://github.com/myparcelnl/sdk/commit/aabdb5681aa897b22cbc99a64a3a0075bf909d36))
* **pps:** make number suffix in drop off point non-nullable ([#397](https://github.com/myparcelnl/sdk/issues/397)) ([7fb25fe](https://github.com/myparcelnl/sdk/commit/7fb25fed5a862f8be7ad66a871cd03962c434646))
* use proprietary variable name in env ([#388](https://github.com/myparcelnl/sdk/issues/388)) ([2e6a84a](https://github.com/myparcelnl/sdk/commit/2e6a84a66d0912aa0b94fb7525328f5207061851))

## [6.1.0](https://github.com/myparcelnl/sdk/compare/v6.0.0...v6.1.0) (2021-12-31)


### :bug: Bug Fixes

* **consignment:** only validate delivery date if needed ([#364](https://github.com/myparcelnl/sdk/issues/364)) ([2f34c53](https://github.com/myparcelnl/sdk/commit/2f34c53cfa2d7528321f55aadbdde9f516094416))
* **pps:** export delivery options ([#360](https://github.com/myparcelnl/sdk/issues/360)) ([c333346](https://github.com/myparcelnl/sdk/commit/c333346f2c3e59b7f0e08782dcd1974d11d6ca13))
* **pps:** export order date with a timestamp ([09eca9c](https://github.com/myparcelnl/sdk/commit/09eca9c668d5ce64fba30f61fde393e85b7fe331))
* **pps:** export Rest of World orders ([#358](https://github.com/myparcelnl/sdk/issues/358)) ([97da682](https://github.com/myparcelnl/sdk/commit/97da682f2b7528ba49b9edd6bb64307c3b49df6f))


### :sparkles: New Features

* **consignment:** make email nullable ([#373](https://github.com/myparcelnl/sdk/issues/373)) ([867b54a](https://github.com/myparcelnl/sdk/commit/867b54a69b8a8ad1d37357565af20174b4915725))
* **pps:** allow setting of label description ([289d0d1](https://github.com/myparcelnl/sdk/commit/289d0d1e830adf8d476b2aa1465dd156f2eca1fa))
* **recipient:** add region property ([#367](https://github.com/myparcelnl/sdk/issues/367)) ([32a1d38](https://github.com/myparcelnl/sdk/commit/32a1d38bbd8bce4798cf6e9682bb52922c380258))
* **recipient:** add setFullStreet ([#349](https://github.com/myparcelnl/sdk/issues/349)) ([9f40418](https://github.com/myparcelnl/sdk/commit/9f40418d2a52b8d7d984f06858c0e78d55c5fc0d))
