# Changelog - Dyronics Custom Modifications

## [5.2.17] - 2026-01-14

### CRITICAL FIX - Barcode Data Persistence
- **FIXED: Barcode data niet zichtbaar na refresh**
  - `$order->save()` toegevoegd na `getShipmentData()` call
  - WooCommerce order metadata werd niet gepersisteerd
  - Shipment data werd opgehaald maar niet opgeslagen in database
  - Success message toonde correct maar data verdween bij page reload

**IMPORTANT**: Na barcode refresh moet order expliciet opgeslagen worden!

---

## [5.2.16] - 2026-01-14

### Type Error Fix - Barcode Refresh
- **FIXED: "Argument #1 ($ids) must be of type array, string given"**
  - `getShipmentData()` verwacht array maar kreeg string van `_myparcel_last_shipment_ids`
  - Toegevoegd automatische conversie: string → array
  - Ondersteunt JSON format, comma-separated values, of single ID
  - Ensures type safety before calling `getShipmentData()`

---

## [5.2.15] - 2026-01-14

### Barcode Refresh AJAX Fix
- **FIXED: "AJAX request failed" bij barcode ophalen**
  - Nonce verificatie accepteert nu zowel `$_POST['_wpnonce']` als `$_GET['_wpnonce']`
  - Betere error messages voor debugging
  - Toegevoegd `return` statements na `wp_send_json_error()` calls

---

## [5.2.14] - 2026-01-14

### License Validation Fix
- **FIXED: "Licentie niet geldig" melding na succesvolle activatie**
  - `is_license_valid()` accepteert nu zowel 'valid' als 'active' status
  - Consistentie tussen activatie (slaat 'active' op) en validatie (checkte alleen 'valid')
  - Verwijderd automatic reverification bij elke check (was te agressief)
  - Admin notices tonen nu correct "geen licentie" vs "licentie expired/invalid"

---

## [5.2.13] - 2026-01-14

### License System Fixes
- **FIXED: License activation now works correctly** 
  - Fixed signature generation to use `hash_hmac()` instead of `hash()`
  - Updated secret key to match API server: `DYR0N1C5_L1C3N53_53CR3T_K3Y_2026`
  - Ajax activation now properly calls `/license/activate` endpoint
  - Ajax deactivation now properly calls `/license/deactivate` endpoint
  - Stores complete license data including domain, expiration, and customer name
- **Removed duplicate license manager initialization**
  - License manager is now only initialized from main plugin file
  - Fixed duplicate "MyParcel Licentie" menu items in WooCommerce menu

---

## [5.2.12] - 2026-01-14

### License & Diagnostics UI Enhancement
- **Separate License & Diagnostics Admin Page**
  - Moved from inline settings integration to dedicated page under WooCommerce menu
  - Accessible via WooCommerce → MyParcel Licentie
  - Combined license activation and diagnostic tools in one interface
  - Improved user experience with clear status indicators and action buttons

---

## [5.2.4] - 2026-01-15

### Enhanced Features - Barcode Management
- **Added Refresh Barcode Button** in order metabox for manual barcode retrieval
- **Smart Detection** of orders with shipment IDs but missing barcode data
- **Two-Tier Refresh System**:
  - Orange warning box with prominent "Barcode ophalen" button for orders missing barcode data
  - Small refresh icon next to timestamp for orders with existing track & trace data
- **AJAX-powered** barcode refresh without page navigation
- **User-friendly notifications** with success messages and automatic page reload
- **Backward compatibility** with existing barcode display functionality

### Technical Improvements
- Enhanced order metabox UI with conditional displays
- Improved error handling for AJAX barcode requests
- Added JavaScript event handlers for refresh functionality
- Extended AJAX endpoint for manual barcode retrieval

---

## [5.2.3] - 2026-01-15

### Critical Bug Fixes - Track & Trace Display
- **FIXED: Barcode/track & trace codes now properly display** after shipment creation
  - Previously barcodes were only fetched when `$processDirectly = true`
  - Most exports use `$processDirectly = false` causing missing track & trace data
  - Modified `addShipments()` in `class-wcmp-export.php` to always fetch barcode data
- **Fixed missing `_myparcel_shipments` metadata** causing empty track & trace displays in:
  - WooCommerce order overview pages
  - Individual order edit pages (metabox)
  - Track & trace URLs and status information

### Technical Changes
- Enhanced export process reliability for barcode storage
- Ensures `getShipmentData()` is called for all export scenarios
- Maintains shipment creation functionality while fixing display issues

---

## [5.2.2] - 2026-01-14

### Enhanced Features - License System & Diagnose Tool
- **Added comprehensive diagnose tool** for license troubleshooting
- **Fixed domain sanitization** for consistent signature generation (www/non-www)
- **Improved license authentication** with standardized secret key handling
- **Added server-side diagnostics API** endpoint for real-time troubleshooting

---

## [5.2.1] - 2026-01-14

### Security Improvements
- **Added input sanitization** in `fixAddressInPost()` to prevent XSS attacks
- **Added input sanitization** in split address validation functions
- **Added capability checks** (`edit_shop_orders`) to AJAX handlers:
  - `ajax_save_insurance_settings()`
  - `ajax_delete_export_timestamp()`
- **Enhanced security** for all user input processing

### Bug Fixes - Split Address Fields
- **Fixed critical bug** where `fixAddressInPost()` only worked when `address_1` was empty
  - Now always combines split fields regardless of current `address_1` value
  - Prevents issues with browser autofill and cached data
  - Ensures consistency when using split address fields

- **Improved `getAddress1FromPost()`** validation
  - Added checks for empty fields before combining
  - Prevents crashes with incomplete data
  - Better error handling

- **Enhanced `merge_street_number_suffix()`** robustness
  - Only updates when valid combined address exists
  - Preserves existing data if split fields are empty
  - Safer fallback behavior

- **Added new validation** function `validate_split_address_fields()`
  - Validates street name and house number are filled
  - Accepts both split fields AND `address_1` as valid input
  - Provides specific error messages per field
  - Works for both billing and shipping addresses
  - Prevents false "required field" errors

### Features Added
- **Order-specific insurance settings** in MyParcel Actions metabox
  - Insurance type selector: Standaard / Vast bedrag / Percentage
  - Fixed amount dropdown with all MyParcel insurance amounts
  - Percentage input (1-100% of order subtotal excl. BTW)
  - AJAX save handler with proper security
  - Settings stored in order metadata for per-order overrides

- **Export timestamp tracking**
  - Shows last export date/time per order
  - Shows per-shipment export timestamps
  - Delete functionality with trash icon
  - Visible even without track & trace codes

### Improvements
- **Universal compatibility** - All fixes work for all users in any scenario
- **Backwards compatible** - No breaking changes, works with and without split address fields
- **Better error messages** - More specific validation feedback to users
- **Improved code quality** - Better input validation and error handling throughout

### Technical Details
- Modified files:
  - `includes/class-wcmp-postcode-fields.php` (split address fixes + security)
  - `includes/admin/class-wcmypa-admin.php` (AJAX security + insurance settings)
  - `includes/admin/OrderSettings.php` (insurance getters + calculation)
  - `includes/admin/views/html-myparcel-actions-metabox.php` (insurance UI)
  - `woocommerce-myparcel.php` (version bump)
  - `composer.json` (version bump)

### Notes
- Split address fields ("Gebruik aparte adresvelden") can now be safely enabled
- All changes maintain compatibility with original MyParcel functionality
- Security improvements follow WordPress and WooCommerce best practices
- Input sanitization prevents XSS and injection attacks
- Proper capability checks prevent unauthorized access

---

## Previous Version: [5.2.0]
Original MyParcel for WooCommerce version before Dyronics modifications.
