# MyParcel Barcode Refresh Test Script
# This script tests the new refresh barcode functionality

# Test Order Details:
# Order ID: 246468 (has shipment ID but missing barcode data)
# Shipment ID: 225034695

echo "=== MyParcel Barcode Refresh Test ==="
echo "Date: $(date)"
echo ""

# Check current order metadata BEFORE refresh
echo "1. Current metadata for Order 246468:"
mysql -u wp_nhlaz -p'4v72Q#Ic$b^!QRMf' wp_9476l -e "
SELECT post_id, meta_key, meta_value 
FROM V6AIJ_postmeta 
WHERE post_id = 246468 AND meta_key LIKE '%myparcel%' 
ORDER BY meta_key;"

echo ""
echo "2. Expected Results:"
echo "   - Should have _myparcel_last_shipment_ids: [225034695]"
echo "   - Should NOT have _myparcel_shipments (this is the issue)"
echo ""

# Instructions for manual test
echo "3. Manual Test Steps:"
echo "   a) Go to WooCommerce > Orders"
echo "   b) Edit Order #246468" 
echo "   c) Look for MyParcel metabox on the right side"
echo "   d) Check if you see:"
echo "      - Orange warning box: 'Barcode data ontbreekt'"
echo "      - Blue 'Barcode ophalen' button"
echo "   e) Click the 'Barcode ophalen' button"
echo "   f) Should see success message and page reload"
echo "   g) After reload: barcode/track & trace should be visible"
echo ""

echo "4. Alternative Test - Small refresh button:"
echo "   If order already shows track & trace data:"
echo "   a) Look for small refresh icon next to timestamp"
echo "   b) Click refresh icon to update barcode data"
echo ""

echo "5. Expected AJAX Response:"
echo "   Success: {success: true, data: {message: 'Barcode data refreshed successfully', count: 1}}"
echo "   Error: {success: false, data: 'Error message'}"
echo ""

echo "6. Database changes after successful refresh:"
echo "   - _myparcel_shipments should now contain barcode data"
echo ""

echo "Test script complete. Please follow manual test steps above."